/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelAuthorizationDocument;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.InheritProperties;
import org.kuali.rice.krad.data.provider.annotation.InheritProperty;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.Relationship;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;

@Entity
@Table(name="TRVL_EXP_ITM_T")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelExpenseItem
extends DataObjectBase
implements Serializable {
    private static final long serialVersionUID = -4092206384418712220L;
    @Id
    @Column(name="EXP_ITM_ID", length=10)
    @GeneratedValue(generator="TRVL_EXP_ITM_ID_S")
    @PortableSequenceGenerator(name="TRVL_EXP_ITM_ID_S")
    @Label(value="Id")
    @Description(value="Unique identifier for item")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String travelExpenseItemId;
    @Column(name="TRVL_AUTH_DOC_ID", length=40)
    @Label(value="Travel Authorization Document Id")
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    private String travelAuthorizationDocumentId;
    @Relationship(foreignKeyFields={"travelAuthorizationDocumentId"})
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TRVL_AUTH_DOC_ID", referencedColumnName="TRVL_AUTH_DOC_ID", insertable=false, updatable=false)
    @InheritProperties(value={@InheritProperty(name="documentNumber", label=@Label(value="Travel Authorization Document"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    private TravelAuthorizationDocument travelAuthorizationDocument;
    @Column(name="TRVL_CO_NM")
    private String travelCompanyName;
    @Column(name="EXP_TYP_CD", length=10)
    @Label(value="Expense Type")
    @Description(value="Type of expense")
    private String travelExpenseTypeCd;
    @Column(name="EXP_DESC", length=10)
    @Label(value="Expense Description")
    @Description(value="Description of expense")
    private String expenseDesc;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="EXP_DT")
    @Label(value="Expense Date")
    @Description(value="Date of expense")
    private Date expenseDate;
    @Column(name="EXP_AMT", length=10)
    @Label(value="Expense Amount")
    @Description(value="Amount of expense")
    private BigDecimal expenseAmount;
    @Column(name="EXP_REIMB", nullable=false, length=1)
    @Convert(converter=BooleanYNConverter.class)
    @Label(value="Reimbursable")
    @Description(value="Whether expense is reimbursed to traveler")
    private boolean reimbursable;
    @Column(name="EXP_TXBL", nullable=false, length=1)
    @Convert(converter=BooleanYNConverter.class)
    @Label(value="Taxable")
    @Description(value="Whether expense is taxed")
    private boolean taxable;

    public String getTravelExpenseItemId() {
        return this.travelExpenseItemId;
    }

    public void setTravelExpenseItemId(String travelExpenseItemId) {
        this.travelExpenseItemId = travelExpenseItemId;
    }

    public String getTravelAuthorizationDocumentId() {
        if (StringUtils.isBlank((String)this.travelAuthorizationDocumentId) && this.travelAuthorizationDocument != null) {
            return this.travelAuthorizationDocument.getDocumentNumber();
        }
        return this.travelAuthorizationDocumentId;
    }

    public void setTravelAuthorizationDocumentId(String travelAuthorizationDocumentId) {
        this.travelAuthorizationDocumentId = travelAuthorizationDocumentId;
    }

    public TravelAuthorizationDocument getTravelAuthorizationDocument() {
        return this.travelAuthorizationDocument;
    }

    public void setTravelAuthorizationDocument(TravelAuthorizationDocument travelAuthorizationDocument) {
        this.travelAuthorizationDocument = travelAuthorizationDocument;
    }

    public String getTravelCompanyName() {
        return this.travelCompanyName;
    }

    public void setTravelCompanyName(String travelCompanyName) {
        this.travelCompanyName = travelCompanyName;
    }

    public String getTravelExpenseTypeCd() {
        return this.travelExpenseTypeCd;
    }

    public void setTravelExpenseTypeCd(String travelExpenseTypeCd) {
        this.travelExpenseTypeCd = travelExpenseTypeCd;
    }

    public String getExpenseDesc() {
        return this.expenseDesc;
    }

    public void setExpenseDesc(String expenseDesc) {
        this.expenseDesc = expenseDesc;
    }

    public Date getExpenseDate() {
        return this.expenseDate;
    }

    public void setExpenseDate(Date expenseDate) {
        this.expenseDate = expenseDate;
    }

    public BigDecimal getExpenseAmount() {
        return this.expenseAmount;
    }

    public void setExpenseAmount(BigDecimal expenseAmount) {
        this.expenseAmount = expenseAmount;
    }

    public boolean isReimbursable() {
        return this.reimbursable;
    }

    public void setReimbursable(boolean reimbursable) {
        this.reimbursable = reimbursable;
    }

    public boolean isTaxable() {
        return this.taxable;
    }

    public void setTaxable(boolean taxable) {
        this.taxable = taxable;
    }
}

