/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.dataobject;

import edu.sampleu.travel.dataobject.TravelerType;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.provider.annotation.InheritProperties;
import org.kuali.rice.krad.data.provider.annotation.InheritProperty;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.Relationship;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;

@Entity
@Table(name="TRVL_TRAVELER_DTL_T")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelerDetail
extends DataObjectBase
implements MutableInactivatable {
    private static final long serialVersionUID = -7169083136626617130L;
    @Id
    @GeneratedValue(generator="TRVL_TRAVELER_DTL_ID_S")
    @SequenceGenerator(name="TRVL_TRAVELER_DTL_ID_S", sequenceName="TRVL_TRAVELER_DTL_ID_S", allocationSize=5)
    @Column(name="id", length=40, nullable=false)
    protected String id;
    @Column(name="doc_nbr", length=14)
    protected String documentNumber;
    @Column(name="EMP_PRINCIPAL_ID")
    protected String principalId;
    @Relationship(foreignKeyFields={"principalId"})
    @Transient
    @InheritProperties(value={@InheritProperty(name="principalName", label=@Label(value="Traveler User ID")), @InheritProperty(name="name", label=@Label(value="Traveler Name"))})
    private Person person;
    @Column(name="first_nm", length=40, nullable=false)
    protected String firstName;
    @Column(length=40, nullable=true)
    protected String middleName;
    @Column(name="last_nm", length=40, nullable=false)
    protected String lastName;
    @Column(name="addr_line_1", length=50, nullable=false)
    protected String streetAddressLine1;
    @Column(name="addr_line_2", length=50, nullable=true)
    protected String streetAddressLine2;
    @Column(name="city_nm", length=50, nullable=true)
    protected String cityName;
    @Column(name="postal_state_cd", length=2, nullable=false)
    protected String stateCode;
    @Column(name="postal_cd", length=11, nullable=false)
    protected String zipCode;
    @Column(name="country_cd", length=2, nullable=true)
    protected String countryCode;
    @Column(name="citizenship", length=40, nullable=true)
    protected String citizenship;
    @Column(name="email_addr", length=50, nullable=true)
    protected String emailAddress;
    @Transient
    protected Date dateOfBirth;
    @Column(name="gender", length=1, nullable=false)
    protected String gender;
    @Column(name="phone_nbr", length=20, nullable=true)
    protected String phoneNumber;
    @Column(name="traveler_typ_cd", length=3, nullable=false)
    protected String travelerTypeCode;
    @Relationship(foreignKeyFields={"travelerTypeCode"})
    @Transient
    protected TravelerType travelerType;
    @Column(name="customer_num", length=40, nullable=true)
    protected String customerNumber;
    @Transient
    protected boolean liabilityInsurance;
    @Column(name="drive_lic_num", length=20, nullable=true)
    protected String driversLicenseNumber;
    @Transient
    protected String driversLicenseState;
    @Column(name="drive_lic_exp_dt")
    @Temporal(value=TemporalType.DATE)
    protected Date driversLicenseExpDate;
    @Transient
    protected Boolean notifyTAFinal = Boolean.FALSE;
    @Transient
    protected Boolean notifyTAStatusChange = Boolean.FALSE;
    @Transient
    protected Boolean notifyTERFinal = Boolean.FALSE;
    @Transient
    protected Boolean notifyTERStatusChange = Boolean.FALSE;
    @Column(name="ACTV_IND", nullable=false, length=1)
    protected Boolean active = Boolean.TRUE;
    @Column(name="non_res_alien", length=1, nullable=true)
    protected Boolean nonResidentAlien = Boolean.FALSE;
    @Transient
    protected Boolean motorVehicleRecordCheck = Boolean.FALSE;

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getName() {
        String name = "";
        if (StringUtils.isNotBlank((String)this.getFirstName())) {
            name = name + this.getFirstName();
        }
        if (StringUtils.isNotBlank((String)this.getMiddleName())) {
            name = name + " " + this.getMiddleName();
        }
        if (StringUtils.isNotBlank((String)this.getLastName())) {
            name = name + " " + this.getLastName();
        }
        return name;
    }

    public String getStreetAddressLine1() {
        return this.streetAddressLine1;
    }

    public void setStreetAddressLine1(String streetAddressLine1) {
        this.streetAddressLine1 = streetAddressLine1;
    }

    public String getStreetAddressLine2() {
        return this.streetAddressLine2;
    }

    public void setStreetAddressLine2(String streetAddressLine2) {
        this.streetAddressLine2 = streetAddressLine2;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getStateCode() {
        return this.stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getTravelerTypeCode() {
        return this.travelerTypeCode;
    }

    public void setTravelerTypeCode(String travelerTypeCode) {
        this.travelerTypeCode = travelerTypeCode;
    }

    public TravelerType getTravelerType() {
        return this.travelerType;
    }

    public void setTravelerType(TravelerType travelerType) {
        this.travelerType = travelerType;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public boolean isLiabilityInsurance() {
        return this.liabilityInsurance;
    }

    public void setLiabilityInsurance(boolean liabilityInsurance) {
        this.liabilityInsurance = liabilityInsurance;
    }

    public String getDriversLicenseNumber() {
        return this.driversLicenseNumber;
    }

    public void setDriversLicenseNumber(String driversLicenseNumber) {
        this.driversLicenseNumber = driversLicenseNumber;
    }

    public String getDriversLicenseState() {
        return this.driversLicenseState;
    }

    public void setDriversLicenseState(String driversLicenseState) {
        this.driversLicenseState = driversLicenseState;
    }

    public Date getDriversLicenseExpDate() {
        return this.driversLicenseExpDate;
    }

    public void setDriversLicenseExpDate(Date driversLicenseExpDate) {
        this.driversLicenseExpDate = driversLicenseExpDate;
    }

    public boolean getNotifyTAFinal() {
        return this.notifyTAFinal;
    }

    public boolean getNotifyTAStatusChange() {
        return this.notifyTAStatusChange;
    }

    public boolean getNotifyTERFinal() {
        return this.notifyTERFinal;
    }

    public boolean getNotifyTERStatusChange() {
        return this.notifyTERStatusChange;
    }

    public String getCitizenship() {
        return this.citizenship;
    }

    public void setCitizenship(String citizenship) {
        this.citizenship = citizenship;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isNotifyTAFinal() {
        return this.notifyTAFinal;
    }

    public void setNotifyTAFinal(boolean notifyTAFinal) {
        this.notifyTAFinal = notifyTAFinal;
    }

    public boolean isNotifyTAStatusChange() {
        return this.notifyTAStatusChange;
    }

    public void setNotifyTAStatusChange(boolean notifyTAStatusChange) {
        this.notifyTAStatusChange = notifyTAStatusChange;
    }

    public boolean isNotifyTERFinal() {
        return this.notifyTERFinal;
    }

    public void setNotifyTERFinal(boolean notifyTERFinal) {
        this.notifyTERFinal = notifyTERFinal;
    }

    public boolean isNotifyTERStatusChange() {
        return this.notifyTERStatusChange;
    }

    public void setNotifyTERStatusChange(boolean notifyTERStatusChange) {
        this.notifyTERStatusChange = notifyTERStatusChange;
    }

    public boolean isMotorVehicleRecordCheck() {
        return this.motorVehicleRecordCheck;
    }

    public void setMotorVehicleRecordCheck(boolean motorVehicleRecordCheck) {
        this.motorVehicleRecordCheck = motorVehicleRecordCheck;
    }

    public boolean isNonResidentAlien() {
        return this.nonResidentAlien;
    }

    public void setNonResidentAlien(boolean nonResidentAlien) {
        this.nonResidentAlien = nonResidentAlien;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }
}

