/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;
import org.kuali.rice.krad.labs.LabsTravelAttachment;

@Entity
@Table(name="TRV_ATT_GRP_SAMPLE")
@UifAutoCreateViews(value={UifAutoCreateViewType.LOOKUP})
public class LabsTravelAttachmentGroup
extends DataObjectBase
implements PersistableAttachmentList<LabsTravelAttachment>,
Serializable {
    private static final long serialVersionUID = -7739303391609395867L;
    @Id
    @Column(name="ATT_GRP_NUM", length=10)
    @Label(value="Attachment Group Number")
    @Description(value="Unique identifier for account")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String number;
    @Column(name="ATT_GRP_NAME", length=40)
    @Label(value="Attachment Group Name")
    private String name;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="labsTravelAttachmentGroup")
    protected List<LabsTravelAttachment> attachments;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public List<LabsTravelAttachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList();
        }
        return this.attachments;
    }

    public void setAttachments(List<LabsTravelAttachment> attachments) {
        this.attachments = attachments;
    }
}

