/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs.encryption;

import java.security.GeneralSecurityException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.krad.labs.encryption.EncryptionForm;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/encryption"})
public class EncryptionController
extends UifControllerBase {
    public static final String INPUT_FIELD = "input";
    public static final String ENCRYPTION_ERROR = "labs.encryption.error";
    private EncryptionService encryptionService;

    protected EncryptionForm createInitialForm() {
        EncryptionForm encryptionForm = new EncryptionForm();
        encryptionForm.setEncryptionServiceName(this.getEncryptionService().getClass().getSimpleName());
        return encryptionForm;
    }

    @RequestMapping(params={"methodToCall=encrypt"})
    public ModelAndView encrypt(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        EncryptionForm encryptionForm = (EncryptionForm)form;
        try {
            encryptionForm.setEncryptedText(this.getEncryptionService().encrypt((Object)encryptionForm.getInput()));
            encryptionForm.setDecryptedText(encryptionForm.getInput());
        }
        catch (GeneralSecurityException gse) {
            GlobalVariables.getMessageMap().putError(INPUT_FIELD, ENCRYPTION_ERROR, new String[]{gse.toString()});
        }
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=decrypt"})
    public ModelAndView decrypt(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        EncryptionForm encryptionForm = (EncryptionForm)form;
        try {
            encryptionForm.setEncryptedText(encryptionForm.getInput());
            encryptionForm.setDecryptedText(this.getEncryptionService().decrypt(encryptionForm.getInput()));
        }
        catch (GeneralSecurityException gse) {
            GlobalVariables.getMessageMap().putError(INPUT_FIELD, ENCRYPTION_ERROR, new String[]{gse.toString()});
        }
        return this.getModelAndView(form);
    }

    private EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }
}

