/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

/**
 * This is a utility converter class for use with XStream serializers. This was written to deal with an issue
 * resulting from the use of JODA-Time where unmarshalling of XML was failing.
 * This applies to only DateTime.class fields.
 */
package org.kuali.rice.krad.service.util;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DateTimeConverter implements SingleValueConverter {
    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(DateTime.class);
    }

    @Override
    public String toString(Object obj) {
        return obj.toString();
    }

    @Override
    public Object fromString(String value) {
        return ISODateTimeFormat.dateTimeParser().parseDateTime(value);
    }
}
