/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.exception.PessimisticLockingException;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PessimisticLockServiceImpl
implements PessimisticLockService {
    private static final Logger LOG = LogManager.getLogger(PessimisticLockServiceImpl.class);
    protected DataObjectService dataObjectService;
    protected DataDictionaryService dataDictionaryService;
    protected PermissionService permissionService;
    protected PersonService personService;

    public void delete(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("An invalid blank id was passed to delete a Pessimistic Lock.");
        }
        PessimisticLock lock = (PessimisticLock)this.dataObjectService.find(PessimisticLock.class, (Object)Long.valueOf(id));
        if (lock == null) {
            throw new IllegalArgumentException("Pessimistic Lock with id " + id + " cannot be found in the database.");
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!lock.isOwnedByUser(user) && !this.isPessimisticLockAdminUser(user)) {
            throw new AuthorizationException(user.getName(), "delete", "Pessimistick Lock (id " + id + ")");
        }
        this.delete(lock);
    }

    private void delete(PessimisticLock lock) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting lock: " + lock);
        }
        this.dataObjectService.delete((Object)lock);
    }

    public PessimisticLock generateNewLock(String documentNumber) {
        return this.generateNewLock(documentNumber, GlobalVariables.getUserSession().getPerson());
    }

    public PessimisticLock generateNewLock(String documentNumber, String lockDescriptor) {
        return this.generateNewLock(documentNumber, lockDescriptor, GlobalVariables.getUserSession().getPerson());
    }

    public PessimisticLock generateNewLock(String documentNumber, Person user) {
        return this.generateNewLock(documentNumber, PessimisticLock.DEFAULT_LOCK_DESCRIPTOR, user);
    }

    public PessimisticLock generateNewLock(String documentNumber, String lockDescriptor, Person user) {
        PessimisticLock lock = new PessimisticLock(documentNumber, lockDescriptor, user, GlobalVariables.getUserSession());
        lock = this.save(lock);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated new lock: " + lock);
        }
        return lock;
    }

    public List<PessimisticLock> getPessimisticLocksForDocument(String documentNumber) {
        return new ArrayList<PessimisticLock>(this.dataObjectService.findMatching(PessimisticLock.class, QueryByCriteria.Builder.forAttribute((String)"documentNumber", (Object)documentNumber).build()).getResults());
    }

    public List<PessimisticLock> getPessimisticLocksForSession(String sessionId) {
        return new ArrayList<PessimisticLock>(this.dataObjectService.findMatching(PessimisticLock.class, QueryByCriteria.Builder.forAttribute((String)"sessionId", (Object)sessionId).build()).getResults());
    }

    public boolean isPessimisticLockAdminUser(Person user) {
        return this.getPermissionService().isAuthorized(user.getPrincipalId(), "KR-NS", "Administer Pessimistic Locking", Collections.emptyMap());
    }

    public void releaseAllLocksForUser(List<PessimisticLock> locks, Person user) {
        for (PessimisticLock lock : locks) {
            if (!lock.isOwnedByUser(user)) continue;
            try {
                this.delete(lock);
            }
            catch (RuntimeException ex) {
                if (ex.getCause() != null && ex.getCause().getClass().equals("org.apache.ojb.broker.OptimisticLockException")) {
                    LOG.warn("Suppressing Optimistic Lock Exception. Document Num: " + lock.getDocumentNumber());
                    continue;
                }
                throw ex;
            }
        }
    }

    public void releaseAllLocksForUser(List<PessimisticLock> locks, Person user, String lockDescriptor) {
        for (PessimisticLock lock : locks) {
            if (!lock.isOwnedByUser(user) || !lockDescriptor.equals(lock.getLockDescriptor())) continue;
            try {
                this.delete(lock);
            }
            catch (RuntimeException ex) {
                if (ex.getCause() != null && ex.getCause().getClass().equals("org.apache.ojb.broker.OptimisticLockException")) {
                    LOG.warn("Suppressing Optimistic Lock Exception. Document Num: " + lock.getDocumentNumber());
                    continue;
                }
                throw ex;
            }
        }
    }

    public PessimisticLock save(PessimisticLock lock) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saving lock: " + lock);
        }
        return (PessimisticLock)this.dataObjectService.save((Object)lock, new PersistenceOption[0]);
    }

    public boolean establishPessimisticLocks(Document document, Person user, boolean canEdit) {
        if (this.isPessimisticLockNeeded(document, user, canEdit)) {
            PessimisticLock pessimisticLock = this.createNewPessimisticLock(document, user);
            document.addPessimisticLock(pessimisticLock);
        }
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (!pessimisticLock.isOwnedByUser(user)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPessimisticLockNeeded(Document document, Person user, boolean canEdit) {
        ArrayList<String> userOwnedLockDescriptors = new ArrayList<String>();
        HashMap<String, Set<String>> otherOwnedLockDescriptors = new HashMap<String, Set<String>>();
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (pessimisticLock.isOwnedByUser(user)) {
                userOwnedLockDescriptors.add(pessimisticLock.getLockDescriptor());
                continue;
            }
            if (!otherOwnedLockDescriptors.containsKey(pessimisticLock.getLockDescriptor())) {
                otherOwnedLockDescriptors.put(pessimisticLock.getLockDescriptor(), new HashSet());
            }
            String otherOwnerPrincipalId = pessimisticLock.getOwnedByUser().getPrincipalId();
            ((Set)otherOwnedLockDescriptors.get(pessimisticLock.getLockDescriptor())).add(otherOwnerPrincipalId);
        }
        this.checkExistingPessimisticLocks(document, userOwnedLockDescriptors, otherOwnedLockDescriptors);
        if (userOwnedLockDescriptors.isEmpty() && otherOwnedLockDescriptors.isEmpty()) {
            return canEdit;
        }
        if (document.useCustomLockDescriptors()) {
            String customLockDescriptor = document.getCustomLockDescriptor(user);
            boolean userOwnsCustomLockDescriptor = userOwnedLockDescriptors.contains(customLockDescriptor);
            boolean otherOwnsCustomLockDescriptor = otherOwnedLockDescriptors.containsKey(customLockDescriptor);
            if (!userOwnsCustomLockDescriptor && !otherOwnsCustomLockDescriptor) {
                return canEdit;
            }
        }
        return false;
    }

    protected void checkExistingPessimisticLocks(Document document, List<String> userOwnedLockDescriptors, Map<String, Set<String>> otherOwnedLockDescriptors) {
        for (String userOwnedLockDescriptor : userOwnedLockDescriptors) {
            if (!otherOwnedLockDescriptors.containsKey(userOwnedLockDescriptor)) continue;
            Set<String> otherOwnerPrincipalIds = otherOwnedLockDescriptors.get(userOwnedLockDescriptor);
            String workflowOwnerPrincipalId = this.getWorkflowPessimisticLockOwnerUser().getPrincipalId();
            boolean hasOtherOwners = !otherOwnerPrincipalIds.isEmpty();
            boolean hasMoreThanOneOtherOwner = otherOwnerPrincipalIds.size() > 1;
            boolean hasWorkflowOwner = otherOwnerPrincipalIds.contains(workflowOwnerPrincipalId);
            if (!hasOtherOwners || !hasMoreThanOneOtherOwner && hasWorkflowOwner) continue;
            StringBuilder builder = new StringBuilder("Found an invalid lock status on document number ");
            builder.append(document.getDocumentNumber());
            builder.append(" with current user and other user both having locks concurrently");
            if (document.useCustomLockDescriptors()) {
                builder.append(" for custom lock descriptor '");
                builder.append(userOwnedLockDescriptor);
                builder.append("'");
            }
            builder.append(".");
            LOG.debug(builder.toString());
            throw new PessimisticLockingException(builder.toString());
        }
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Person user) {
        if (document.useCustomLockDescriptors()) {
            return this.generateNewLock(document.getDocumentNumber(), document.getCustomLockDescriptor(user), user);
        }
        return this.generateNewLock(document.getDocumentNumber(), user);
    }

    @Deprecated
    public Set getDocumentActions(Document document, Person user, Set<String> documentActions) {
        if (documentActions.contains("canCancel") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canCancel");
        }
        if (documentActions.contains("canSave") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canSave");
        }
        if (documentActions.contains("canRoute") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canRoute");
        }
        if (documentActions.contains("canBlanketApprove") && !this.hasPreRouteEditAuthorization(document, user)) {
            documentActions.remove("canBlanketApprove");
        }
        return documentActions;
    }

    @Deprecated
    protected boolean hasPreRouteEditAuthorization(Document document, Person user) {
        if (document.getPessimisticLocks().isEmpty()) {
            return true;
        }
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (!lock.isOwnedByUser(user)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean usesPessimisticLocking(Document document) {
        return this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking();
    }

    public void establishWorkflowPessimisticLocking(Document document) {
        PessimisticLock lock = this.createNewPessimisticLock(document, this.getWorkflowPessimisticLockOwnerUser());
        document.addPessimisticLock(lock);
    }

    public void releaseWorkflowPessimisticLocking(Document document) {
        this.releaseAllLocksForUser(document.getPessimisticLocks(), this.getWorkflowPessimisticLockOwnerUser());
        document.refreshPessimisticLocks();
    }

    protected Person getWorkflowPessimisticLockOwnerUser() {
        String networkId = "kr";
        return this.getPersonService().getPersonByPrincipalName(networkId);
    }

    @Deprecated
    public Map establishLocks(Document document, Map editMode, Person user) {
        Map editModeMap = new HashMap();
        ArrayList<String> givenUserLockDescriptors = new ArrayList<String>();
        HashMap lockDescriptorUsers = new HashMap();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(user)) {
                givenUserLockDescriptors.add(lock.getLockDescriptor());
                continue;
            }
            if (!lockDescriptorUsers.containsKey(lock.getLockDescriptor())) {
                lockDescriptorUsers.put(lock.getLockDescriptor(), new HashSet());
            }
            ((Set)lockDescriptorUsers.get(lock.getLockDescriptor())).add(lock.getOwnedByUser());
        }
        for (String givenUserLockDescriptor : givenUserLockDescriptors) {
            Set users;
            if (!lockDescriptorUsers.containsKey(givenUserLockDescriptor) || ((Set)lockDescriptorUsers.get(givenUserLockDescriptor)).size() <= 0 || (users = (Set)lockDescriptorUsers.get(givenUserLockDescriptor)).size() == 1 && this.getWorkflowPessimisticLockOwnerUser().getPrincipalId().equals(((Person)users.iterator().next()).getPrincipalId())) continue;
            Object descriptorText = document.useCustomLockDescriptors() ? " using lock descriptor '" + givenUserLockDescriptor + "'" : "";
            String errorMsg = "Found an invalid lock status on document number " + document.getDocumentNumber() + "with current user and other user both having locks" + (String)descriptorText + " concurrently";
            LOG.debug(errorMsg);
            throw new PessimisticLockingException(errorMsg);
        }
        if (givenUserLockDescriptors.isEmpty()) {
            if (lockDescriptorUsers.isEmpty()) {
                if (this.isLockRequiredByUser(document, editMode, user)) {
                    document.addPessimisticLock(this.createNewPessimisticLock(document, editMode, user));
                }
                editModeMap.putAll(editMode);
            } else if (document.useCustomLockDescriptors()) {
                customLockDescriptor = document.getCustomLockDescriptor(user);
                if (lockDescriptorUsers.containsKey(customLockDescriptor)) {
                    editModeMap = this.getEditModeWithEditableModesRemoved(editMode);
                } else {
                    if (this.isLockRequiredByUser(document, editMode, user)) {
                        document.addPessimisticLock(this.createNewPessimisticLock(document, editMode, user));
                    }
                    editModeMap.putAll(editMode);
                }
            } else {
                editModeMap = this.getEditModeWithEditableModesRemoved(editMode);
            }
        } else if (document.useCustomLockDescriptors()) {
            customLockDescriptor = document.getCustomLockDescriptor(user);
            if (givenUserLockDescriptors.contains(customLockDescriptor)) {
                editModeMap.putAll(editMode);
            } else if (lockDescriptorUsers.containsKey(customLockDescriptor)) {
                editModeMap = this.getEditModeWithEditableModesRemoved(editMode);
            } else {
                if (this.isLockRequiredByUser(document, editMode, user)) {
                    document.addPessimisticLock(this.createNewPessimisticLock(document, editMode, user));
                }
                editModeMap.putAll(editMode);
            }
        } else {
            editModeMap.putAll(editMode);
        }
        return editModeMap;
    }

    @Deprecated
    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected Map getEditModeWithEditableModesRemoved(Map currentEditMode) {
        HashMap editModeMap = new HashMap();
        for (Map.Entry entry : currentEditMode.entrySet()) {
            if (this.isEntryEditMode(entry)) {
                editModeMap.putAll(this.getEntryEditModeReplacementMode(entry));
                continue;
            }
            editModeMap.put(entry.getKey(), entry.getValue());
        }
        return editModeMap;
    }

    @Deprecated
    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return StringUtils.equalsIgnoreCase((String)"true", (String)fullEntryEditModeValue);
        }
        return false;
    }

    protected Map getEntryEditModeReplacementMode(Map.Entry entry) {
        HashMap<String, String> editMode = new HashMap<String, String>();
        editMode.put("viewOnly", "true");
        return editMode;
    }

    @Deprecated
    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document.useCustomLockDescriptors()) {
            return this.generateNewLock(document.getDocumentNumber(), document.getCustomLockDescriptor(user), user);
        }
        return this.generateNewLock(document.getDocumentNumber(), user);
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    @Required
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

