/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.List;
import java.util.concurrent.Callable;
import javax.persistence.OptimisticLockException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.AfterProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.BeforeProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.DeleteEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentLockingEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.PostProcessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.LegacyUtils;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PostProcessorServiceImpl
implements PostProcessorService {
    private static final Logger LOG = LogManager.getLogger(PostProcessorServiceImpl.class);
    private DocumentService documentService;

    public ProcessDocReport doRouteStatusChange(final DocumentRouteStatusChange statusChangeEvent) throws Exception {
        return (ProcessDocReport)LegacyUtils.doInLegacyContext((String)statusChangeEvent.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isInfoEnabled()) {
                        LOG.info((CharSequence)new StringBuilder("started handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(statusChangeEvent.getDocumentId())) == null) {
                        if (!"X".equals(statusChangeEvent.getNewRouteStatus())) {
                            throw new RuntimeException("unable to load document " + statusChangeEvent.getDocumentId());
                        }
                    } else {
                        document.doRouteStatusChange(statusChangeEvent);
                        if (!document.getDocumentHeader().getWorkflowDocument().isSaved()) {
                            document = PostProcessorServiceImpl.this.documentService.updateDocument(document);
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((CharSequence)new StringBuilder("finished handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("route status", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport doRouteLevelChange(final DocumentRouteLevelChange levelChangeEvent) throws Exception {
        return (ProcessDocReport)LegacyUtils.doInLegacyContext((String)levelChangeEvent.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuilder("started handling route level change from ").append(levelChangeEvent.getOldNodeName()).append(" to ").append(levelChangeEvent.getNewNodeName()).append(" for document ").append(levelChangeEvent.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(levelChangeEvent.getDocumentId())) == null) {
                        throw new RuntimeException("unable to load document " + levelChangeEvent.getDocumentId());
                    }
                    document.populateDocumentForRouting();
                    document.doRouteLevelChange(levelChangeEvent);
                    document.getDocumentHeader().getWorkflowDocument().saveDocumentData();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuilder("finished handling route level change from ").append(levelChangeEvent.getOldNodeName()).append(" to ").append(levelChangeEvent.getNewNodeName()).append(" for document ").append(levelChangeEvent.getDocumentId()));
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("route level", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport doDeleteRouteHeader(DeleteEvent event) throws Exception {
        return new ProcessDocReport(true, "");
    }

    public ProcessDocReport doActionTaken(final ActionTakenEvent event) throws Exception {
        return (ProcessDocReport)LegacyUtils.doInLegacyContext((String)event.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuilder("started doing action taken for action taken code").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId())) == null) {
                        if (!"X".equals(event.getActionTaken().getActionTaken().getCode())) {
                            LOG.warn("doActionTaken() Unable to load document with id " + event.getDocumentId() + " using action taken code '" + (String)KewApiConstants.ACTION_TAKEN_CD.get(event.getActionTaken().getActionTaken().getCode()));
                        }
                    } else {
                        document.doActionTaken(event);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuilder("finished doing action taken for action taken code").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("do action taken", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport afterActionTaken(final ActionType performed, final ActionTakenEvent event) throws Exception {
        return (ProcessDocReport)LegacyUtils.doInLegacyContext((String)event.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuilder("started doing after action taken for action performed code " + performed.getCode() + " and action taken code ").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId())) == null) {
                        if (!"X".equals(event.getActionTaken().getActionTaken().getCode())) {
                            LOG.warn("afterActionTaken() Unable to load document with id " + event.getDocumentId() + " using action taken code '" + (String)KewApiConstants.ACTION_TAKEN_CD.get(event.getActionTaken().getActionTaken().getCode()));
                        }
                    } else {
                        document.afterActionTaken(performed, event);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuilder("finished doing after action taken for action taken code").append(event.getActionTaken().getActionTaken()).append(" for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("do action taken", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport afterProcess(final AfterProcessEvent event) throws Exception {
        return (ProcessDocReport)LegacyUtils.doInLegacyContext((String)event.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuilder("started after process method for document ").append(event.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId())) == null) {
                        LOG.warn("afterProcess() Unable to load document with id " + event.getDocumentId() + "... ignoring post processing");
                    } else {
                        document.afterWorkflowEngineProcess(event.isSuccessfullyProcessed());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuilder("finished after process method for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("after process", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public ProcessDocReport beforeProcess(final BeforeProcessEvent event) throws Exception {
        return (ProcessDocReport)LegacyUtils.doInLegacyContext((String)event.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuilder("started before process method for document ").append(event.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId())) == null) {
                        LOG.warn("beforeProcess() Unable to load document with id " + event.getDocumentId() + "... ignoring post processing");
                    } else {
                        document.beforeWorkflowEngineProcess();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuilder("finished before process method for document ").append(event.getDocumentId()));
                        }
                    }
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("before process", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    public List<String> getDocumentIdsToLock(final DocumentLockingEvent event) throws Exception {
        return (List)LegacyUtils.doInLegacyContext((String)event.getDocumentId(), (UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                try {
                    Document document;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)new StringBuilder("started get document ids to lock method for document ").append(event.getDocumentId()));
                    }
                    if ((document = PostProcessorServiceImpl.this.documentService.getByDocumentHeaderId(event.getDocumentId())) != null) {
                        List documentIdsToLock = document.getWorkflowEngineDocumentIdsToLock();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((CharSequence)new StringBuilder("finished get document ids to lock method for document ").append(event.getDocumentId()));
                        }
                        if (documentIdsToLock == null) {
                            return null;
                        }
                        return documentIdsToLock;
                    }
                    LOG.warn("getDocumentIdsToLock() Unable to load document with id " + event.getDocumentId() + "... ignoring post processing");
                }
                catch (Exception e) {
                    PostProcessorServiceImpl.this.logAndRethrow("before process", e);
                }
                return null;
            }
        });
    }

    private void logAndRethrow(String changeType, Exception e) throws RuntimeException {
        LOG.error("caught exception while handling " + changeType + " change", (Throwable)e);
        this.logOptimisticDetails(5, e);
        throw new RuntimeException("post processor caught exception while handling " + changeType + " change: " + e.getMessage(), e);
    }

    private void logOptimisticDetails(int depth, Throwable t) {
        if (depth > 0 && t != null) {
            Object sourceObject = null;
            boolean optLockException = false;
            if (t instanceof OptimisticLockException) {
                sourceObject = ((OptimisticLockException)t).getEntity();
                optLockException = true;
            } else if (t instanceof OptimisticLockingFailureException) {
                sourceObject = ((OptimisticLockingFailureException)t).getMessage();
                optLockException = true;
            } else if (t.getClass().getName().equals("org.apache.ojb.broker.OptimisticLockException")) {
                try {
                    sourceObject = PropertyUtils.getSimpleProperty((Object)t, (String)"sourceObject");
                }
                catch (Exception ex) {
                    LOG.warn("Unable to retrieve source object from OJB OptimisticLockException", (Throwable)ex);
                }
                optLockException = true;
            }
            if (optLockException) {
                if (sourceObject != null) {
                    if (sourceObject instanceof String) {
                        LOG.error("source of OptimisticLockException Unknown.  Message: " + sourceObject);
                    } else {
                        LOG.error("source of OptimisticLockException = " + sourceObject.getClass().getName() + " ::= " + sourceObject);
                    }
                }
            } else {
                Throwable cause = t.getCause();
                if (cause != t) {
                    this.logOptimisticDetails(--depth, cause);
                }
            }
        }
    }

    public final void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected UserSession establishPostProcessorUserSession() throws WorkflowException {
        if (GlobalVariables.getUserSession() == null) {
            return new UserSession("kr");
        }
        return GlobalVariables.getUserSession();
    }
}

