/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.document.DocumentAuthorizerBase;
import org.kuali.rice.krad.document.DocumentPresentationController;
import org.kuali.rice.krad.document.DocumentPresentationControllerBase;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentPresentationControllerBase;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class DocumentDictionaryServiceImpl
implements DocumentDictionaryService {
    private DataDictionaryService dataDictionaryService;

    public String getLabel(String documentTypeName) {
        String label = null;
        DocumentType docType = this.getDocumentType(documentTypeName);
        if (docType != null) {
            label = docType.getLabel();
        }
        return label;
    }

    public String getMaintenanceDocumentTypeName(Class dataObjectClass) {
        String documentTypeName = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(dataObjectClass);
        if (entry != null) {
            documentTypeName = entry.getDocumentTypeName();
        }
        return documentTypeName;
    }

    public String getDescription(String documentTypeName) {
        String description = null;
        DocumentType docType = this.getDocumentType(documentTypeName);
        if (docType != null) {
            description = docType.getDescription();
        }
        return description;
    }

    public Collection getDefaultExistenceChecks(Class dataObjectClass) {
        return this.getDefaultExistenceChecks(this.getMaintenanceDocumentTypeName(dataObjectClass));
    }

    public Collection getDefaultExistenceChecks(Document document) {
        return this.getDefaultExistenceChecks(this.getDocumentEntry(document).getDocumentTypeName());
    }

    public Collection getDefaultExistenceChecks(String docTypeName) {
        List defaultExistenceChecks = null;
        DocumentEntry entry = this.getDocumentEntry(docTypeName);
        if (entry != null) {
            defaultExistenceChecks = entry.getDefaultExistenceChecks();
        }
        return defaultExistenceChecks;
    }

    public Class<?> getMaintenanceDataObjectClass(String docTypeName) {
        Class dataObjectClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            dataObjectClass = entry.getDataObjectClass();
        }
        return dataObjectClass;
    }

    public Class<? extends Maintainable> getMaintainableClass(String docTypeName) {
        Class maintainableClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            maintainableClass = entry.getMaintainableClass();
        }
        return maintainableClass;
    }

    public Class<? extends BusinessRule> getBusinessRulesClass(Document document) {
        Class businessRulesClass = null;
        String docTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentEntry entry = this.getDocumentEntry(docTypeName);
        if (entry != null) {
            businessRulesClass = entry.getBusinessRulesClass();
        }
        return businessRulesClass;
    }

    public Boolean getAllowsCopy(Document document) {
        Boolean allowsCopy = Boolean.FALSE;
        if (document == null) {
            return allowsCopy;
        }
        DocumentEntry entry = null;
        if (document instanceof MaintenanceDocument) {
            MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
            if (maintenanceDocument.getNewMaintainableObject() != null) {
                entry = this.getMaintenanceDocumentEntry(maintenanceDocument.getNewMaintainableObject().getDataObjectClass());
            }
        } else {
            entry = this.getDocumentEntry(document);
        }
        if (entry != null) {
            allowsCopy = entry.getAllowsCopy();
        }
        return allowsCopy;
    }

    public Boolean getAllowsNewOrCopy(String docTypeName) {
        MaintenanceDocumentEntry entry;
        Boolean allowsNewOrCopy = Boolean.FALSE;
        if (docTypeName != null && (entry = this.getMaintenanceDocumentEntry(docTypeName)) != null) {
            allowsNewOrCopy = entry.getAllowsNewOrCopy();
        }
        return allowsNewOrCopy;
    }

    public DocumentEntry getDocumentEntry(String documentTypeName) {
        if (documentTypeName == null) {
            throw new IllegalArgumentException("invalid (null) document type name");
        }
        DocumentEntry entry = this.getDataDictionary().getDocumentEntry(documentTypeName);
        return entry;
    }

    public DocumentEntry getDocumentEntryByClass(Class<? extends Document> documentClass) {
        DocumentEntry entry = null;
        String documentTypeName = this.getDocumentTypeByClass(documentClass);
        if (StringUtils.isNotBlank((String)documentTypeName)) {
            entry = this.getDocumentEntry(documentTypeName);
        }
        return entry;
    }

    public MaintenanceDocumentEntry getMaintenanceDocumentEntry(String docTypeName) {
        if (StringUtils.isBlank((String)docTypeName)) {
            throw new IllegalArgumentException("invalid (blank) docTypeName");
        }
        MaintenanceDocumentEntry entry = (MaintenanceDocumentEntry)this.getDataDictionary().getDocumentEntry(docTypeName);
        return entry;
    }

    public Class<?> getDocumentClassByName(String documentTypeName) {
        Class documentClass = null;
        DocumentEntry entry = this.getDocumentEntry(documentTypeName);
        if (entry != null) {
            documentClass = entry.getDocumentClass();
        }
        return documentClass;
    }

    public String getDocumentTypeByClass(Class<? extends Document> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("invalid (null) document class");
        }
        DocumentEntry entry = this.getDataDictionary().getDocumentEntry(documentClass.getName());
        if (entry != null) {
            return entry.getDocumentTypeName();
        }
        return null;
    }

    public Boolean getAllowsRecordDeletion(Class dataObjectClass) {
        Boolean allowsRecordDeletion = Boolean.FALSE;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(dataObjectClass);
        if (docEntry != null) {
            allowsRecordDeletion = docEntry.getAllowsRecordDeletion();
        }
        return allowsRecordDeletion;
    }

    public Boolean getAllowsRecordDeletion(MaintenanceDocument document) {
        return document != null ? this.getAllowsRecordDeletion(document.getNewMaintainableObject().getDataObjectClass()) : Boolean.FALSE;
    }

    public List<String> getLockingKeys(String docTypeName) {
        List lockingKeys = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            lockingKeys = entry.getLockingKeyFieldNames();
        }
        return lockingKeys;
    }

    public boolean getPreserveLockingKeysOnCopy(Class dataObjectClass) {
        boolean preserveLockingKeysOnCopy = false;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(dataObjectClass);
        if (docEntry != null) {
            preserveLockingKeysOnCopy = docEntry.getPreserveLockingKeysOnCopy();
        }
        return preserveLockingKeysOnCopy;
    }

    public List<String> getClearValueOnCopyPropertyNames(Class dataObjectClass) {
        List clearValueOnCopyPropertyNames = null;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(dataObjectClass);
        if (docEntry != null) {
            clearValueOnCopyPropertyNames = docEntry.getClearValueOnCopyPropertyNames();
        }
        return clearValueOnCopyPropertyNames;
    }

    public DocumentAuthorizer getDocumentAuthorizer(String documentType) {
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        if (StringUtils.isBlank((String)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        DocumentEntry documentEntry = dataDictionary.getDocumentEntry(documentType);
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class documentAuthorizerClass = documentEntry.getDocumentAuthorizerClass();
        Object documentAuthorizer = null;
        try {
            documentAuthorizer = documentAuthorizerClass != null ? (DocumentAuthorizer)documentAuthorizerClass.newInstance() : (documentEntry instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentAuthorizerBase() : new DocumentAuthorizerBase());
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentAuthorizer '" + documentAuthorizerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentAuthorizer;
    }

    public DocumentAuthorizer getDocumentAuthorizer(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentAuthorizer documentAuthorizer = this.getDocumentAuthorizer(documentType);
        return documentAuthorizer;
    }

    public DocumentPresentationController getDocumentPresentationController(String documentType) {
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        if (StringUtils.isBlank((String)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        DocumentEntry documentEntry = dataDictionary.getDocumentEntry(documentType);
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class documentPresentationControllerClass = documentEntry.getDocumentPresentationControllerClass();
        Object documentPresentationController = null;
        try {
            documentPresentationController = documentPresentationControllerClass != null ? (DocumentPresentationController)documentPresentationControllerClass.newInstance() : (documentEntry instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentPresentationControllerBase() : new DocumentPresentationControllerBase());
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentAuthorizer '" + documentPresentationControllerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentPresentationController;
    }

    public DocumentPresentationController getDocumentPresentationController(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentPresentationController documentPresentationController = this.getDocumentPresentationController(documentType);
        return documentPresentationController;
    }

    protected MaintenanceDocumentEntry getMaintenanceDocumentEntry(Class dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (blank) dataObjectClass");
        }
        MaintenanceDocumentEntry entry = this.getDataDictionary().getMaintenanceDocumentEntryForBusinessObjectClass(dataObjectClass);
        return entry;
    }

    protected DocumentEntry getDocumentEntry(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        DocumentEntry entry = this.getDataDictionary().getDocumentEntry(document.getClass().getName());
        return entry;
    }

    protected DocumentType getDocumentType(String documentTypeName) {
        return KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(documentTypeName);
    }

    protected DataDictionary getDataDictionary() {
        return this.getDataDictionaryService().getDataDictionary();
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

