/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.kim;

import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.krad.kim.DocumentTypePermissionTypeServiceImpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentTypeAndAttachmentTypePermissionTypeService extends DocumentTypePermissionTypeServiceImpl {

	@Override
	protected List<Permission> performPermissionMatches(
			Map<String, String> requestedDetails,
			List<Permission> permissionsList) {

		List<Permission> matchingPermissions = new ArrayList<Permission>();
		if (requestedDetails == null) {
			return matchingPermissions; // empty list
		}
		// loop over the permissions, checking the non-document-related ones
		for (Permission kimPermissionInfo : permissionsList) {
            PermissionBo bo = PermissionBo.from(kimPermissionInfo);
			if (!bo.getDetails().containsKey(
						KimConstants.AttributeConstants.ATTACHMENT_TYPE_CODE)
			  || bo.getDetails().get(KimConstants.AttributeConstants.ATTACHMENT_TYPE_CODE)
				 .equals(requestedDetails.get(KimConstants.AttributeConstants.ATTACHMENT_TYPE_CODE)))
			{
				matchingPermissions.add(kimPermissionInfo);
			}

		}
		// now, filter the list to just those for the current document
		matchingPermissions = super.performPermissionMatches(requestedDetails,
				matchingPermissions);
		
		// if we have more than one permission for the document, then we need to check if any have an attachment type code
		// if so, we throw away the "less specific" one without an attachment type code
		if ( matchingPermissions.size() > 1 ) {
			Iterator<Permission> permIter = matchingPermissions.iterator();
			while ( permIter.hasNext() ) {
				if ( !permIter.next().getAttributes().containsKey(KimConstants.AttributeConstants.ATTACHMENT_TYPE_CODE) ) {
					permIter.remove();
				}
			}
		}
		
		return matchingPermissions;
	}
}
