/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service.impl;

import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.DocumentHeaderService;

/**
 *
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentHeaderServiceImpl implements DocumentHeaderService {

    protected DataObjectService dataObjectService;

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentHeader getDocumentHeaderById(String documentHeaderId) {
        return dataObjectService.find(DocumentHeader.class, documentHeaderId);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DocumentHeader saveDocumentHeader(DocumentHeader documentHeader) {
        WorkflowDocument workflowDocument = documentHeader.getWorkflowDocument();
        DocumentHeader savedDocumentHeader = dataObjectService.save(documentHeader, PersistenceOption.FLUSH);
        savedDocumentHeader.setWorkflowDocument( workflowDocument );
        return savedDocumentHeader;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void deleteDocumentHeader(DocumentHeader documentHeader) {
    	dataObjectService.delete(documentHeader);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

}
