/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import java.io.Serializable;

import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

/**
 * Defines methods common to all DataDictionaryDefinition types.
 */
public interface DataDictionaryDefinition extends DictionaryBean, Serializable {

    /**
     * Performs complete intra-definition validation which couldn't be done earlier - for example, verifies that field
     * references
     * refer to actual fields of some specific class.
     *
     * @param rootBusinessObjectClass Class of the BusinessObjectEntry which ultimately contains this definition
     * @param otherBusinessObjectClass other stuff required to complete validation
     * @throws org.kuali.rice.krad.datadictionary.exception.CompletionException if a problem arises during
     * validation-completion
     */
    @Deprecated
    void completeValidation(Class<?> rootBusinessObjectClass, Class<?> otherBusinessObjectClass);

    /**
     * Performs complete intra-definition validation which couldn't be done earlier - for example, verifies that field
     * references
     * refer to actual fields of some specific class.
     *
     * @param rootBusinessObjectClass Class of the BusinessObjectEntry which ultimately contains this definition
     * @param otherBusinessObjectClass other stuff required to complete validation
     * @param tracer {@link ValidationTrace} class used to track what was being validated at the time of any problems discovered
     */
    void completeValidation(Class<?> rootBusinessObjectClass, Class<?> otherBusinessObjectClass, ValidationTrace tracer);

    String getId();
}
