/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import java.util.List;

public class DocumentCollectionPath extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = -8165456163213868710L;

    protected String collectionPath;
    protected List<String> paths;
    protected DocumentCollectionPath nestedCollection;

    /**
     * @return the documentValues
     */
    public List<String> getDocumentValues() {
        return this.paths;
    }

    /**
     * @return the documentCollectionPath
     */
    public DocumentCollectionPath getNestedCollection() {
        return this.nestedCollection;
    }

    /**
     * @param paths the documentValues to set
     */
    public void setDocumentValues(List<String> paths) {
        this.paths = paths;
    }

    /**
     * @param documentCollectionPath the documentCollectionPath to set
     */
    public void setNestedCollection(DocumentCollectionPath documentCollectionPath) {
        this.nestedCollection = documentCollectionPath;
    }

    /**
     * @return the collectionPath
     */
    public String getCollectionPath() {
        return this.collectionPath;
    }

    /**
     * @param collectionPath the collectionPath to set
     */
    public void setCollectionPath(String collectionPath) {
        this.collectionPath = collectionPath;
    }
}
