/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import java.util.List;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

@BeanTag(name = "documentValuePathGroup")
public class DocumentValuePathGroup extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = 6285682208264817105L;

    protected List<String> paths;
    protected DocumentCollectionPath documentCollectionPath;

    /**
     * @return the documentValues
     */
    @BeanTagAttribute(name = "paths", type = BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getDocumentValues() {
        return this.paths;
    }

    /**
     * @return the documentCollectionPath
     */
    @BeanTagAttribute(name = "documentCollectionPath", type = BeanTagAttribute.AttributeType.SINGLEBEAN)
    public DocumentCollectionPath getDocumentCollectionPath() {
        return this.documentCollectionPath;
    }

    /**
     * @param paths the documentValues to set
     */
    public void setDocumentValues(List<String> paths) {
        this.paths = paths;
    }

    /**
     * @param documentCollectionPath the documentCollectionPath to set
     */
    public void setDocumentCollectionPath(DocumentCollectionPath documentCollectionPath) {
        this.documentCollectionPath = documentCollectionPath;
    }

}
