/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

/**
 * Performs overrides on properties of fields in a Data Dictionary bean.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface FieldOverride {
    /**
     * Return the property name to perform the override.
     *
     * @return property name
     */
    public String getPropertyName();

    /**
     * perform the override.
     *
     * @param bean data dictionary bean
     * @param property original property value
     * @return overridden property value
     */
    public Object performFieldOverride(Object bean, Object property);
}
