/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import java.util.List;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

@BeanTag(name = "routingTypeDefinition")
public class RoutingTypeDefinition extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = -5455042765223753531L;

    protected List<RoutingAttribute> routingAttributes;
    protected List<DocumentValuePathGroup> documentValuePathGroups;

    /**
     * @return the routingAttributes
     */
    @BeanTagAttribute(name = "routingAttributes", type = BeanTagAttribute.AttributeType.LISTBEAN)
    public List<RoutingAttribute> getRoutingAttributes() {
        return this.routingAttributes;
    }

    /**
     * @return the documentValuePathGroups
     */
    @BeanTagAttribute(name = "documentValuePathGroups", type = BeanTagAttribute.AttributeType.LISTBEAN)
    public List<DocumentValuePathGroup> getDocumentValuePathGroups() {
        return this.documentValuePathGroups;
    }

    /**
     * @param routingAttributes the routingAttributes to set
     */
    public void setRoutingAttributes(List<RoutingAttribute> routingAttributes) {
        this.routingAttributes = routingAttributes;
    }

    /**
     * @param documentValuePathGroups the documentValuePathGroups to set
     */
    public void setDocumentValuePathGroups(List<DocumentValuePathGroup> documentValuePathGroups) {
        this.documentValuePathGroups = documentValuePathGroups;
    }

}
