/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

@BeanTag(name = "searchingAttribute")
public class SearchingAttribute extends WorkflowAttributeMetadata {
    private static final long serialVersionUID = -612461988789474893L;

    private String businessObjectClassName;
    private String attributeName;
    private boolean showAttributeInSearchCriteria = true;
    private boolean showAttributeInResultSet = false;

    /**
     * @return the businessObjectClassName
     */
    @BeanTagAttribute(name = "businessObjectClassName")
    public String getBusinessObjectClassName() {
        return this.businessObjectClassName;
    }

    /**
     * @return the attributeName
     */
    @BeanTagAttribute(name = "attributeName")
    public String getAttributeName() {
        return this.attributeName;
    }

    /**
     * @param businessObjectClassName the businessObjectClassName to set
     */
    public void setBusinessObjectClassName(String businessObjectClassName) {
        this.businessObjectClassName = businessObjectClassName;
    }

    /**
     * @param attributeName the attributeName to set
     */
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    /**
     * Returns whether this attribute should appear in the search criteria
     *
     * @return the showAttributeInSearchCriteria
     */
    @BeanTagAttribute(name = "showAttriubteInSearchCriteria")
    public boolean isShowAttributeInSearchCriteria() {
        return this.showAttributeInSearchCriteria;
    }

    /**
     * Sets whether this attribute should appear in the search criteria
     *
     * @param showAttributeInSearchCriteria the showAttributeInSearchCriteria to set
     */
    public void setShowAttributeInSearchCriteria(boolean showAttributeInSearchCriteria) {
        this.showAttributeInSearchCriteria = showAttributeInSearchCriteria;
    }

    /**
     * Returns whether this attribute should appear in the result set
     *
     * @return the showAttributeInResultSet
     */
    @BeanTagAttribute(name = "ShowAttributeInResultSet")
    public boolean isShowAttributeInResultSet() {
        return this.showAttributeInResultSet;
    }

    /**
     * Sets whether this attribute should appear in the result set
     *
     * @param showAttributeInResultSet the showAttributeInResultSet to set
     */
    public void setShowAttributeInResultSet(boolean showAttributeInResultSet) {
        this.showAttributeInResultSet = showAttributeInResultSet;
    }
}
