/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.exporter;

import org.kuali.rice.core.api.exception.RiceRuntimeException;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Adds a litle strong type-checking and validation on top of the generic LinkedHashMap
 */
@Deprecated
public class StringMap extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 7364206011639131063L;

    /**
     * Associates the given String with the given Map value.
     *
     * @param key
     * @param value
     */
    public void set(String key, Map<String, Object> value) {
        setUnique(key, value);
    }

    /**
     * Associates the given String with the given String value.
     *
     * @param key
     * @param value
     */
    public void set(String key, String value) {
        setUnique(key, value);
    }

    /**
     * Verifies that the key isn't blank, and that the value isn't null, and prevents duplicate keys from being used.
     *
     * @param key
     * @param value
     */
    private void setUnique(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("invalid (null) value");
        }

        if (containsKey(key)) {
            throw new RiceRuntimeException("duplicate key '" + key + "'");
        }

        super.put(key, value);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("direct calls to put not supported");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException("direct calls to put not supported");
    }
}
