/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.uif;

import java.util.HashMap;
import java.util.Map;

import org.kuali.rice.krad.datadictionary.DataDictionaryException;

/**
 * Holds view index information for a view type, where the index keys are built
 * from the supported view type parameters
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ViewTypeDictionaryIndex {
    private Map<String, String> viewIndex;

    public ViewTypeDictionaryIndex() {
        viewIndex = new HashMap<String, String>();
    }

    public Map<String, String> getViewIndex() {
        return this.viewIndex;
    }

    public void setViewIndex(Map<String, String> viewIndex) {
        this.viewIndex = viewIndex;
    }

    public void put(String index, String beanName) {
        if (viewIndex.containsKey(index)) {
            throw new DataDictionaryException("Two Views: (" + viewIndex.get(index) + " and " + beanName + ") must not share the same type index: " + index);
        }

        viewIndex.put(index, beanName);
    }

    public String get(String index) {
        if (viewIndex.containsKey(index)) {
            return viewIndex.get(index);
        }

        return null;
    }

}
