/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.capability;

import org.kuali.rice.krad.datadictionary.validation.constraint.ExistenceConstraint;

/**
 * Validation capability to constrain a value to be required or not required to be non-empty.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ExistenceConstrainable extends Constrainable, ExistenceConstraint {

    // To match up with legacy code for AttributeDefinition, the existence constraint isRequired() member is a field
    // on the definition, making the capability a sub-interface of the constraint

}
