/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.Serializable;

import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.provider.ConstraintProvider;
import org.kuali.rice.krad.datadictionary.validation.processor.ConstraintProcessor;

/**
 * This is the marker interface for constraints. Constraints are a central concept in the Rice data dictionary
 * validation, and are the
 * primary mechanism by which the validation of an object or one of its attributes takes place. For example, by
 * imposing
 * a length constraint
 * on an attribute of a business object, it's possible to indicate that only values shorter (or longer) than a specific
 * number of characters
 * are valid for that attribute.
 *
 * Any interface that extends Constraint is by definition a constraint, and may have one of the following defined:
 *
 * - A sub-interface for {@link Constrainable} that advises on how a constraint maps to data dictionary metadata
 * - A {@link ConstraintProvider} that looks up constraints for a specific constrainable definition
 * - A {@link ConstraintProcessor} that processes the constraint against some object value to determine if it is valid
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 1.1
 */
public interface Constraint extends Serializable {

    // Empty - since this is a marker interface, all of the interesting stuff is in interfaces or classes that extend this interface

}
