/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint;

/**
 * Constraint that restricts the length of a string to some predefined maximum and/or minimum
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 1.1
 */
public interface LengthConstraint extends DataTypeConstraint {

    /**
     * Determines the maximum size of the field
     *
     * <p>
     * The maximum size is used for data entry, data edit and display purposes.
     * </p>
     *
     * @return Integer specifying maximum length of field
     */
    Integer getMaxLength();

    /**
     * Determines the minimum size of the field
     *
     * <p>
     * The minimum size is used for data entry, data edit and display purposes.
     * </p>
     *
     * @return Integer specifying minimum length of field
     */
    Integer getMinLength();

}
