/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * This abstract class extends from ValidCharactersConstraint. Its subclasses contain a regex that
 * is built out with flags that can be turned off and on. All ValidCharactersPatternConstraints
 * allow a certain set of characters to be repeated multiple times
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "validCharactersPatternContraint")
public abstract class ValidCharactersPatternConstraint extends ValidCharactersConstraint {
    /**
     * Warning: This value should NOT be set on ValidCharactersPatternConstraints as the value is
     * built dynamically from the flags set on the constraint - if this value IS set it will
     * override any automatic generation and only use that which was set through this method for
     * server side validation
     *
     * @see org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint#setValue(java.lang.String)
     */
    @Override
    public void setValue(String value) {
        super.setValue(value);
    }

    /**
     * @see org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint#getValue()
     */
    @Override
    @BeanTagAttribute(name = "value")
    public String getValue() {
        if (StringUtils.isEmpty(value)) {
            return "^" + getRegexString() + "*$";
        }
        return value;

    }

    /**
     * This method returns a string representing a regex with characters to match, this string
     * should not include the start(^) and end($) symbols or any length related symbols (*, {0,},
     * etc)
     *
     * @return regular expression
     */
    abstract protected String getRegexString();

}
