/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint.provider;

import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.ViewAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.DataTypeConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.LengthConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.CaseConstraintResolver;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.ConstraintResolver;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.DefinitionConstraintResolver;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.MustOccurConstraintsResolver;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.PrerequisiteConstraintsResolver;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.SimpleConstraintResolver;
import org.kuali.rice.krad.datadictionary.validation.constraint.resolver.ValidCharactersConstraintResolver;
import org.kuali.rice.krad.uif.field.InputField;

import java.util.HashMap;

/**
 * AttributeDefinitionConstraintProvider looks up constraints for attribute definitions by constraint type
 *
 * <p> This can either by instantiated by dependency
 * injection, in which case a map of class names to constraint resolvers can be injected, or the default map can be
 * constructed by
 * calling the init() method immediately after instantiation.</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class AttributeDefinitionConstraintProvider extends BaseConstraintProvider<AttributeDefinition> {

    @Override
    public void init() {
        resolverMap = new HashMap<String, ConstraintResolver<AttributeDefinition>>();
        resolverMap.put(SimpleConstraint.class.getName(), new SimpleConstraintResolver<AttributeDefinition>());
        resolverMap.put(CaseConstraint.class.getName(), new CaseConstraintResolver<AttributeDefinition>());
        resolverMap.put(DataTypeConstraint.class.getName(), new DefinitionConstraintResolver<AttributeDefinition>());
        resolverMap.put(LengthConstraint.class.getName(), new DefinitionConstraintResolver<AttributeDefinition>());
        resolverMap.put(ValidCharactersConstraint.class.getName(),
                new ValidCharactersConstraintResolver<AttributeDefinition>());
        resolverMap.put(PrerequisiteConstraint.class.getName(),
                new PrerequisiteConstraintsResolver<AttributeDefinition>());
        resolverMap.put(MustOccurConstraint.class.getName(), new MustOccurConstraintsResolver<AttributeDefinition>());
    }

    /**
     * @see org.kuali.rice.krad.datadictionary.validation.constraint.provider.ConstraintProvider#isSupported(org.kuali.rice.krad.datadictionary.validation.capability.Constrainable)
     */
    @Override
    public boolean isSupported(Constrainable definition) {

        if (definition instanceof AttributeDefinition
                || definition instanceof InputField
                || definition instanceof ViewAttributeValueReader.InputFieldConstrainableInfo) {
            return true;
        }

        return false;
    }

}
