/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint.resolver;

import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;

import java.util.Collections;
import java.util.List;

/**
 * An object that returns the constrainable definition itself as a list for a definition implementing the capability
 * {@link Constrainable}.
 * This definition must also implement the interface {@link Constraint}, or a ClassCastException will be thrown.
 *
 * @param <T> constrainable type
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DefinitionConstraintResolver<T extends Constrainable> implements ConstraintResolver<T> {

    @Override
    public <C extends Constraint> List<C> resolve(T definition) throws ClassCastException {
        if (definition instanceof Constraint) {
            @SuppressWarnings("unchecked") C constraint = (C) definition;
            return Collections.singletonList(constraint);
        }
        /*        else if(definiton instanceof InputField){
            C constraint = (C)definition.get
        }*/
        throw new ClassCastException(
                "DefinitionConstraintResolver can only be used for a definition that implements both Constraint and Constrainable, or derives from a class that does.");
    }

}
