/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint.resolver;

import org.kuali.rice.krad.datadictionary.validation.capability.PrerequisiteConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;

import java.util.List;

/**
 * An object that returns the list of prerequisite constraints for a definition implementing the capability {@link
 * PrerequisiteConstrainable}.
 *
 * @param <T> constrainable type
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PrerequisiteConstraintsResolver<T extends PrerequisiteConstrainable> implements ConstraintResolver<T> {

    @SuppressWarnings("unchecked")
    @Override
    public <C extends Constraint> List<C> resolve(T definition) {
        return (List<C>) definition.getPrerequisiteConstraints();
    }

}
