/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.processor;

import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;

import java.util.Collection;

/**
 * CollectionConstraintProcessor is a marker interface for 'collection constraint processors'
 *
 * <p>It is a constraint processor that tests collections
 * rather than their elements. Maybe the best example of a collection-based constraint is a constraint on the number of
 * elements
 * in that collection -- for example, a constraint that ensures that there are between 1 and 10 elements in a
 * collection.</p>
 *
 * @param <T> collection type
 * @param <C> constraint type
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CollectionConstraintProcessor<T extends Collection<?>, C extends Constraint> extends ConstraintProcessor<T, C> {
    // Empty
}
