/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.processor;

import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;

/**
 * @param <C> constraint type
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class OptionalElementConstraintProcessor<C extends Constraint> implements ConstraintProcessor<Object, C> {

    /**
     * @see org.kuali.rice.krad.datadictionary.validation.processor.ConstraintProcessor#isOptional()
     */
    @Override
    public boolean isOptional() {
        return true;
    }

}
