/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.result;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttributeValidationResult implements Serializable {

    private String attributeName;
    private Map<String, ConstraintValidationResult> constraintValidationResultMap;

    /**
     * creates a new instance with the given attribute name
     *
     * @param attributeName - the attribute name
     */
    public AttributeValidationResult(String attributeName) {
        this.attributeName = attributeName;
        this.constraintValidationResultMap = new LinkedHashMap<String, ConstraintValidationResult>();
    }

    /**
     * adds a constraint validation result
     *
     * @param constraintValidationResult - the constraint validation result to set
     */
    public void addConstraintValidationResult(ConstraintValidationResult constraintValidationResult) {
        constraintValidationResultMap.put(constraintValidationResult.getConstraintName(), constraintValidationResult);
    }

    /**
     * gets an iterator over the constraint validation results added to this class
     *
     * @return an iterator to stored constraint validation results
     */
    public Iterator<ConstraintValidationResult> iterator() {
        return constraintValidationResultMap.values().iterator();
    }

    /**
     * gets a constraint validation result with the given constraintName
     *
     * @param constraintName - a descriptive name of the current constraint processor
     * @return validation result
     */
    protected ConstraintValidationResult getConstraintValidationResult(String constraintName) {
        ConstraintValidationResult constraintValidationResult = constraintValidationResultMap.get(constraintName);
        if (constraintValidationResult == null) {
            constraintValidationResult = new ConstraintValidationResult(constraintName);
            constraintValidationResultMap.put(constraintName, constraintValidationResult);
        }
        return constraintValidationResult;
    }

    /**
     * @return the attributeName
     */
    public String getAttributeName() {
        return this.attributeName;
    }

    /**
     * @param attributeName the attributeName to set
     */
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

}
