/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.document;

import org.kuali.rice.kew.api.exception.WorkflowException;

/**
 * Defines methods a Copyable document must implement.
 */
public interface Copyable {
    
    /**
     * Converts this Document instance into a copy of itself.
     * 
     * @throws WorkflowException If the copy operation fails.
     */
    public void toCopy() throws WorkflowException;
    
}
