/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.document;

import org.kuali.rice.krad.uif.view.RequestAuthorizationCache;

/**
 * Determines what actions are applicable to the given document, irrespective of user
 * or other state.  These initial actions are used as inputs for further filtering depending
 * on context.
 * @see DocumentAuthorizer
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentPresentationController {

    public boolean canInitiate(String documentTypeName);

    public boolean canEdit(Document document);

    public boolean canAnnotate(Document document);

    public boolean canReload(Document document);

    public boolean canClose(Document document);

    public boolean canSave(Document document);

    public boolean canRoute(Document document);

    public boolean canCancel(Document document);

    public boolean canCopy(Document document);

    public boolean canPerformRouteReport(Document document);

    public boolean canAddAdhocRequests(Document document);

    public boolean canBlanketApprove(Document document);

    public boolean canApprove(Document document);

    public boolean canDisapprove(Document document);

    public boolean canSendAdhocRequests(Document document);

    public boolean canSendNoteFyi(Document document);

    public boolean canEditDocumentOverview(Document document);

    public boolean canFyi(Document document);

    public boolean canAcknowledge(Document document);

    public boolean canComplete(Document document);

    /**
     * @since 2.1
     */
    public boolean canRecall(Document document);

    /**
     * Determines if the document state should allow a super user taking an action.
     *
     * @param document document to check
     *
     * @return true the document state should allow a super user taking an action, otherwise false
     *
     * @since 2.5
     */
    boolean canSuperUserTakeAction(Document document);

    /**
     * Determines if the document state should allow a super user approving the document.
     *
     * @param document document to check
     *
     * @return true if the document state should allow a super user approving the document, otherwise false
     *
     * @since 2.5
     */
    boolean canSuperUserApprove(Document document);

    /**
     * Determines if the document state should allow a super user disapproving the document.
     *
     * @param document document to check
     *
     * @return true if the document state should allow a super user disapproving the document, otherwise false
     *
     * @since 2.5
     */
    boolean canSuperUserDisapprove(Document document);

    void setDocumentRequestAuthorizationCache(DocumentRequestAuthorizationCache documentRequestAuthorizationCache);

}
