/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.keyvalues;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.util.KRADConstants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * This class returns list of boolean key value pairs.
 *
 *
 */
public class IndicatorValuesFinder extends KeyValuesBase {

	public static final IndicatorValuesFinder INSTANCE = new IndicatorValuesFinder();

	protected static final List<KeyValue> ACTIVE_LABELS;
	static {
		final List<KeyValue> activeLabels = new ArrayList<KeyValue>(3);
        activeLabels.add(new ConcreteKeyValue(KRADConstants.YES_INDICATOR_VALUE, "Yes"));
        activeLabels.add(new ConcreteKeyValue(KRADConstants.NO_INDICATOR_VALUE, "No"));
        activeLabels.add(new ConcreteKeyValue("", "Both"));

        ACTIVE_LABELS = Collections.unmodifiableList(activeLabels);
	}

    @Override
	public List<KeyValue> getKeyValues() {
        return ACTIVE_LABELS;
    }
}
