/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

/**
 * Wraps a {@link List} and if truncated keeps the complete size
 *
 * @param <T> list item type
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class CollectionIncomplete<T> implements List<T>, RandomAccess, Serializable {
    private static final long serialVersionUID = 8683452581122892189L;

    private final List<T> list;
    private Long actualSizeIfTruncated;

    /**
     * Collection that may be incomplete/truncated.
     *
     * @param collection collection instance to be wrapped
     * @param actualSizeIfTruncated the actual collection size before truncation.  Zero if the collection is not
     * truncated.
     */
    public CollectionIncomplete(Collection<T> collection, Long actualSizeIfTruncated) {
        super();

        this.list = new ArrayList<T>(collection);
        this.actualSizeIfTruncated = actualSizeIfTruncated;
    }

    /**
     * @see java.util.List#add(int, Object)
     */
    @Override
    public void add(int arg0, T arg1) {
        list.add(arg0, arg1);
    }

    /**
     * @see java.util.List#add(Object)
     */
    @Override
    public boolean add(T arg0) {
        return list.add(arg0);
    }

    /**
     * @see java.util.List#addAll(int, java.util.Collection)
     */
    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        return list.addAll(arg0, arg1);
    }

    /**
     * @see java.util.List#addAll(java.util.Collection)
     */
    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        return list.addAll(arg0);
    }

    /**
     * @see java.util.List#clear()
     */
    @Override
    public void clear() {
        list.clear();
    }

    /**
     * @see java.util.List#contains(Object)
     */
    @Override
    public boolean contains(Object arg0) {
        return list.contains(arg0);
    }

    /**
     * @see java.util.List#containsAll(java.util.Collection)
     */
    @Override
    public boolean containsAll(Collection<?> arg0) {
        return list.containsAll(arg0);
    }

    /**
     * @see java.util.List#equals(Object)
     */
    @Override
    public boolean equals(Object arg0) {
        return list.equals(arg0);
    }

    /**
     * @see java.util.List#get(int)
     */
    @Override
    public T get(int arg0) {
        return list.get(arg0);
    }

    /**
     * @see java.util.List#hashCode()
     */
    @Override
    public int hashCode() {
        return list.hashCode();
    }

    /**
     * @see java.util.List#indexOf(Object)
     */
    @Override
    public int indexOf(Object arg0) {
        return list.indexOf(arg0);
    }

    /**
     * @see java.util.List#isEmpty()
     */
    @Override
    public boolean isEmpty() {
        return list.isEmpty();
    }

    /**
     * @see java.util.List#iterator()
     */
    @Override
    public Iterator<T> iterator() {
        return list.iterator();
    }

    /**
     * @see java.util.List#lastIndexOf(Object)
     */
    @Override
    public int lastIndexOf(Object arg0) {
        return list.lastIndexOf(arg0);
    }

    /**
     * @see java.util.List#listIterator()
     */
    @Override
    public ListIterator<T> listIterator() {
        return list.listIterator();
    }

    /**
     * @see java.util.List#listIterator(int)
     */
    @Override
    public ListIterator listIterator(int arg0) {
        return list.listIterator(arg0);
    }

    /**
     * @see java.util.List#remove(int)
     */
    @Override
    public T remove(int arg0) {
        return list.remove(arg0);
    }

    /**
     * @see java.util.List#remove(Object)
     */
    @Override
    public boolean remove(Object arg0) {
        return list.remove(arg0);
    }

    /**
     * @see java.util.List#removeAll(java.util.Collection)
     */
    @Override
    public boolean removeAll(Collection<?> arg0) {
        return list.removeAll(arg0);
    }

    /**
     * @see java.util.List#retainAll(java.util.Collection)
     */
    @Override
    public boolean retainAll(Collection<?> arg0) {
        return list.retainAll(arg0);
    }

    /**
     * @see java.util.List#set(int, Object)
     */
    @Override
    public T set(int arg0, T arg1) {
        return list.set(arg0, arg1);
    }

    /**
     * @see java.util.List#size()
     */
    @Override
    public int size() {
        return list.size();
    }

    /**
     * @see java.util.List#subList(int, int)
     */
    @Override
    public List<T> subList(int arg0, int arg1) {
        return list.subList(arg0, arg1);
    }

    /**
     * @see java.util.List#toArray()
     */
    @Override
    public Object[] toArray() {
        return list.toArray();
    }

    /**
     * @see java.util.List#toArray(Object[])
     */
    @Override
    public <T> T[] toArray(T[] arg0) {
        return list.toArray(arg0);
    }

    /**
     * @see java.util.List#toString()
     */
    @Override
    public String toString() {
        return list.toString();
    }

    /**
     * Get the actual collection size if the collection was truncated
     *
     * <p>
     * For non-truncated collection the <code>getActualSizeIfTruncated</code> is zero.
     * </p>
     *
     * @return Returns the actualSizeIfTruncated.
     */
    public Long getActualSizeIfTruncated() {
        return actualSizeIfTruncated;
    }

    /**
     * Set the actual collection size if the collection was truncated
     *
     * @param actualSizeIfTruncated The actualSizeIfTruncated to set.
     */
    public void setActualSizeIfTruncated(Long actualSizeIfTruncated) {
        this.actualSizeIfTruncated = actualSizeIfTruncated;
    }
}
