/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.AddAdHocRoutePersonRule;
import org.kuali.rice.krad.rules.rule.BusinessRule;

/**
 * This class represents the add AdHocRoutePerson event that is part of an eDoc in Kuali. This is triggered when a user presses the
 * add button for a given adHocRoutePerson.
 *
 *
 */
public final class AddAdHocRoutePersonEvent extends DocumentEventBase {
    private AdHocRoutePerson adHocRoutePerson;

    /**
     * Constructs an AddAdHocRoutePersonEvent with the specified errorPathPrefix, document, and adHocRoutePerson
     *
     * @param document
     * @param adHocRoutePerson
     * @param errorPathPrefix
     */
    public AddAdHocRoutePersonEvent(String errorPathPrefix, Document document, AdHocRoutePerson adHocRoutePerson) {
        super("creating add ad hoc route person event for document " + DocumentEventBase.getDocumentId(document), errorPathPrefix, document);
        this.adHocRoutePerson = adHocRoutePerson;
    }

    /**
     * Constructs an AddAdHocRoutePersonEvent with the given document
     *
     * @param document
     * @param adHocRoutePerson
     */
    public AddAdHocRoutePersonEvent(Document document, AdHocRoutePerson adHocRoutePerson) {
        this("", document, adHocRoutePerson);
    }

    /**
     * This method retrieves the document adHocRoutePerson associated with this event.
     *
     * @return AdHocRoutePerson
     */
    public AdHocRoutePerson getAdHocRoutePerson() {
        return adHocRoutePerson;
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.DocumentEvent#validate()
     */
    @Override
    public void validate() {
        super.validate();
        if (this.adHocRoutePerson == null) {
            throw new IllegalArgumentException("invalid (null) document adHocRoutePerson");
        }
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.DocumentEvent#getRuleInterfaceClass()
     */
    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddAdHocRoutePersonRule.class;
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.DocumentEvent#invokeRuleMethod(org.kuali.rice.krad.rules.rule.BusinessRule)
     */
    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddAdHocRoutePersonRule) rule).processAddAdHocRoutePerson(getDocument(), this.adHocRoutePerson);
    }
}
