/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

/**
 * Event class for document audit
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class DocumentAuditEvent extends DocumentEventBase {

    /**
     * Constructs a RunAuditEvent with the given errorPathPrefix and document.
     *
     * @param errorPathPrefix
     * @param document
     */
    public DocumentAuditEvent(String errorPathPrefix, Document document) {
        super("Running audit on " + DocumentEventBase.getDocumentId(document), errorPathPrefix, document);
    }

    /**
     * Constructs a RunAuditEvent with the given document.
     *
     * @param document
     */
    public DocumentAuditEvent(Document document) {
        this("", document);
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.RuleEvent#getRuleInterfaceClass()
     */
    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return DocumentAuditRule.class;
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.RuleEvent#invokeRuleMethod(org.kuali.rice.krad.rules.rule.BusinessRule)
     */
    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((DocumentAuditRule) rule).processRunAuditBusinessRules(getDocument());
    }
}

