/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.component;

/**
 * Components that change their template (or other logic) based on whether they are rendered in a list (as
 * a list item) should implement this interface.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ListAware {

    /**
     * Sets the boolean indicator on the component that indicates whether it is being rendered
     * in a list
     *
     * @param renderedInList boolean true if rendered in a list, false if not
     */
    void setRenderedInList(boolean renderedInList);
}
