/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.component;

/**
 * Extends <code>Ordered</code> interface to add setter for the order property
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Ordered extends org.springframework.core.Ordered {
	public static final int INITIAL_ORDER_VALUE = 0;

	/**
	 * Setter for the order value
	 *
	 * @param order
	 * @see org.springframework.core.Ordered#getOrder()
	 */
	public void setOrder(int order);
}
