/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.component;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for <code>Component</code> fields to indicate only the property
 * reference should be made (as opposed to a new object) when doing a component
 * copy
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Target({ ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ReferenceCopy {

	/**
	 * Indicates whether a new collection instance should be made with
	 * collection elements copied by reference
	 *
	 * @return boolean true if new collection instance should be made, false if
	 *         the whole collection should be copied by reference
	 */
	boolean newCollectionInstance() default false;

    /**
     * Indicates that a field should be omitted from copying.
     * 
     * @return true if the field should be omitted from copying, false to follow
     *         {@link #newCollectionInstance()} semantics.
     */
    boolean referenceTransient() default false;

}
