/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.container;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;

import java.util.HashSet;
import java.util.Set;

/**
 * Special <code>Group</code> that renders a tab navigation section
 *
 * <p>
 * Only supports <code>Action</code> instances within the container. These
 * are used to provide the items (or individual links) within the navigation.
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "tabNavigationGroup-bean", parent = "Uif-TabNavigationGroup")
public class TabNavigationGroup extends GroupBase {
    private static final long serialVersionUID = -7263923392768546340L;

    public TabNavigationGroup() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        Set<Class<? extends Component>> supportedComponents = new HashSet<Class<? extends Component>>();
        supportedComponents.add(Action.class);

        return supportedComponents;
    }
}
