/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * OptionListControl is used for listing out options from an option finder or options list.  This control can show all
 * items in the options or it can show only the selected options (if backed by a propertyName).  One use case for this
 * control is to use it in combination with UifKeyValueLocation to provide a list of locations retrieved through a
 * KeyValuesFinder.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "optionListControl", parent = "Uif-OptionListControl")
public class OptionListControl extends MultiValueControlBase {
    private static final long serialVersionUID = 8249529888721507155L;

    private String itemCssClass;
    private String selectedItemCssClass;
    private boolean showOnlySelected;

    /**
     * The item css class to add to each li element of the list
     *
     * @return the item css class
     */
    @BeanTagAttribute
    public String getItemCssClass() {
        return itemCssClass;
    }

    /**
     * Set the itemCssClass
     *
     * @param itemCssClass
     */
    public void setItemCssClass(String itemCssClass) {
        this.itemCssClass = itemCssClass;
    }

    /**
     * When true, only show the "selected" options (items which match a value in the property of the field).  Otherwise,
     * show all options.
     *
     * @return true if only showing selected options, otherwise show all
     */
    @BeanTagAttribute
    public boolean isShowOnlySelected() {
        return showOnlySelected;
    }

    /**
     * Set the showOnlySelected flag
     *
     * @param showOnlySelected
     */
    public void setShowOnlySelected(boolean showOnlySelected) {
        this.showOnlySelected = showOnlySelected;
    }

    /**
     * The css class to add to each item of the list which matches a value in the property
     *
     * @return the selected item css class
     */
    @BeanTagAttribute
    public String getSelectedItemCssClass() {
        return selectedItemCssClass;
    }

    /**
     * Set the selectedItemCssClass
     *
     * @param selectedItemCssClass
     */
    public void setSelectedItemCssClass(String selectedItemCssClass) {
        this.selectedItemCssClass = selectedItemCssClass;
    }
}
