/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

/**
 * Control interface for a select box. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface SelectControl extends Control, MultiValueControl, SizedControl {

    /**
     * Indicates whether multiple values can be selected. Defaults to false
     * <p>
     * If multiple is set to true, the underlying property must be of Array type
     * </p>
     *
     * @return true if multiple values can be selected, false if only
     *         one value can be selected
     */
    boolean isMultiple();

    /**
     * Set whether multiple values can be selected
     *
     * @param multiple
     */
    void setMultiple(boolean multiple);

}
