/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;

/**
 * Represents a HTML Select control. Provides preset options for the User to
 * choose from by a drop down
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "dropdownControl", parent = "Uif-DropdownControl"),
        @BeanTag(name = "multiSelectControl", parent = "Uif-MultiSelectControl")})
public class SelectControlBase extends MultiValueControlBase implements SelectControl {
    private static final long serialVersionUID = 6443247954759096815L;

    private int size;
    private boolean multiple;

    public SelectControlBase() {
        size = 1;
        multiple = false;
    }


    @Override
    @BeanTagAttribute
    public int getSize() {
        return this.size;
    }


    @Override
    public void setSize(int size) {
        this.size = size;
    }

    /**
     * Indicates whether multiple values can be selected. Defaults to false
     * <p>
     * If multiple is set to true, the underlying property must be of Array type
     * </p>
     *
     * @return true if multiple values can be selected, false if only
     *         one value can be selected
     */
    @Override
    @BeanTagAttribute
    public boolean isMultiple() {
        return this.multiple;
    }

    /**
     * Set whether multiple values can be selected
     *
     * @param multiple
     */
    @Override
    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }
}
