/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

/**
 * Indicates <code>Control</code> types that can be configured with a static value to submit, as opposed to pulling
 * the value from the underlying property
 *
 * <p>
 * Examples of this are {@link CheckboxControl}, which can be configured with a value that will be submitted when the
 * checkbox is checked. For example, suppose we had a model property of type Set&lt;String&gt; that represents selected car
 * types. In the UI, we can present a list of available car types with a checkbox next to each. The value for the
 * each checkbox will be the model type of the associated role: 'Ford', 'GM', 'Honda'. For each checkbox selected the
 * associated value will be submitted and populated into the Set&lt;String&gt; on the model.
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ValueConfiguredControl {

    /**
     * Retrieves the value that will be submitted with the control
     *
     * @return String control value
     */
    public String getValue();

    /**
     * Setter for the value that should be submitted with the control
     *
     * @param value
     */
    public void setValue(String value);
}
