/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.element;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ErrorReport;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

import java.util.ArrayList;

/**
 * Content element that encloses an iframe
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "iFrame", parent = "Uif-Iframe")
public class Iframe extends ContentElementBase {
    private static final long serialVersionUID = 5797473302619055088L;

    private String source;
    private String height;
    private String frameborder;

    public Iframe() {
        super();
    }

    /**
     * The IFrame's source
     *
     * @return source
     */
    @BeanTagAttribute
    public String getSource() {
        return this.source;
    }

    /**
     * Setter for the IFrame's source
     *
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /**
     * The IFrame's height
     *
     * @return height
     */
    @BeanTagAttribute
    public String getHeight() {
        return this.height;
    }

    /**
     * Setter for the IFrame's height
     *
     * @param height
     */
    public void setHeight(String height) {
        this.height = height;
    }

    /**
     * The IFrame's frame border
     *
     * @return frameborder
     */
    @BeanTagAttribute
    public String getFrameborder() {
        return this.frameborder;
    }

    /**
     * Setter for the IFrame's frame border
     *
     * @param frameborder
     */
    public void setFrameborder(String frameborder) {
        this.frameborder = frameborder;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);

        // Checks that a source is set
        if (getSource() == null) {
            if (!Validator.checkExpressions(this, "source")) {
                String currentValues[] = {"source =" + getSource()};
                tracer.createError("Source must be set", currentValues);
            }
        }

        super.completeValidation(tracer.getCopy());
    }
}
