/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.field;

import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * Data field security adds attribute security to the standard component security
 *
 * <p>
 * The {@link AttributeSecurity} can be configured for the field to indicate there is security at the data layer
 * (configured by component (class) and property). If the field is backed by a data dictionary
 * {@link org.kuali.rice.krad.datadictionary.AttributeDefinition} the attribute security can be configured there and
 * will be picked up and inserted into the field security
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "dataFieldSecurity")
public class DataFieldSecurity extends FieldSecurity {
    private static final long serialVersionUID = 585138507596582667L;

    private AttributeSecurity attributeSecurity;

    public DataFieldSecurity() {
        super();
    }

    /**
     * Attribute security instance configured or picked up for the field
     *
     * @return AttributeSecurity instance
     */
    @BeanTagAttribute(type= BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public AttributeSecurity getAttributeSecurity() {
        return attributeSecurity;
    }

    /**
     * Setter for the fields attribute security
     *
     * @param attributeSecurity
     */
    public void setAttributeSecurity(AttributeSecurity attributeSecurity) {
        this.attributeSecurity = attributeSecurity;
    }

}
