/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.freemarker;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;

import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.layout.StackedLayoutManager;

import freemarker.core.Environment;
import freemarker.core.InlineTemplateAdaptor;
import freemarker.template.TemplateException;

/**
 * Inline FreeMarker template adaptor for supporting stacked.ftl 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FreeMarkerStackedAdaptor implements InlineTemplateAdaptor, Serializable {

    private static final long serialVersionUID = -4442716566711789593L;

    /**
     * Render a KRAD collection via the stacked layout manager inline.
     * 
     * {@inheritDoc}
     */
    @Override
    public void accept(Environment env) throws TemplateException, IOException {
        @SuppressWarnings("unchecked")
        List<? extends Component> items = FreeMarkerInlineRenderUtils.resolve(env, "items", List.class);
        StackedLayoutManager manager = FreeMarkerInlineRenderUtils.resolve(env, "manager", StackedLayoutManager.class);
        CollectionGroup container = FreeMarkerInlineRenderUtils.resolve(env, "container", CollectionGroup.class);
        FreeMarkerInlineRenderUtils.renderStacked(env, items, manager, container);
    }

}
