/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;

/**
 * Handles delivery of per-node parse state for path-based view lifecycle algorithms.
 * 
 * <p>
 * The interface is used for assigning the path property value during the {@link View}'s pre-process
 * phase.
 * </p>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface LifecycleElementState {
    
    /**
     * Gets the view lifecycle phase constant that corresponds to this phase processing task.
     * 
     * @return view lifecycle phase constant corresponding to this phase
     * @see org.kuali.rice.krad.uif.UifConstants.ViewPhases
     */
    String getViewPhase();

    /**
     * Gets the path relative to the view.
     * 
     * @return path relative the the view
     */
    String getViewPath();
    
    /**
     * Gets the element this lifecycle phase is responsible for processing.
     * 
     * @return element this lifecycle phase is responsible for processing
     */
    LifecycleElement getElement();

    /**
     * Gets the path relative the predecessor phase's component.
     * 
     * @return path relative the predecessor phase's component
     */
    String getParentPath();

    /**
     * Gets the depth of the element in the lifecycle tree.
     * 
     * @return The depth of the element in the lifecycle tree.
     */
    int getDepth();

}
