/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

/**
 * Abstract base lifecycle processor implementation.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class ViewLifecycleProcessorBase implements ViewLifecycleProcessor {

    /**
     * The view lifecycle to be processed.
     */
    private final ViewLifecycle lifecycle;

    /**
     * Creates a new processor for a lifecycle.
     * 
     * @param lifecycle The lifecycle to process.
     */
    ViewLifecycleProcessorBase(ViewLifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ViewLifecycle getLifecycle() {
        return lifecycle;
    }

    /**
     * Reports a phase as active on the current thread.
     * 
     * <p>
     * Since each {@link ViewLifecycle} instance is specific to a thread, only one phase may be
     * active at a time.
     * </p>
     * 
     * @param phase The phase to report as active, or null when the active phase has been
     *        completed.
     * @see #getActivePhase()
     */
    abstract void setActivePhase(ViewLifecyclePhase phase);

}
