/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.initialize;

import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.lifecycle.LifecycleElementState;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

/**
 * Invokes {@link Copyable#preventModification()} on the lifecycle element.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PrepareForCacheTask extends ViewLifecycleTaskBase<LifecycleElement> {

    /**
     * Creates an instance based on element state.
     */
    public PrepareForCacheTask() {
        super(LifecycleElement.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void performLifecycleTask() {
        LifecycleElementState elementState = getElementState();
        LifecycleElement element = elementState.getElement();
        String viewStatus = element.getViewStatus();
        
        element.setViewStatus(UifConstants.ViewStatus.CACHED);
        if (!UifConstants.ViewStatus.CREATED.equals(viewStatus) && !UifConstants.ViewStatus.CACHED.equals(viewStatus)) {
            ViewLifecycle.reportIllegalState("View status is "
                    + viewStatus
                    + " prior to caching "
                    + getClass().getName()
                    + " "
                    + element.getId()
                    + ", expected C or X");
        }

        viewStatus = UifConstants.ViewStatus.CACHED;
    }

}
