/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.initialize;

import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;

/**
 * Sort items in a container
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SortContainerTask extends ViewLifecycleTaskBase<Container> {

    public SortContainerTask() {
        super(Container.class);
    }

    @Override
    protected void performLifecycleTask() {
            Container container = (Container) getElementState().getElement();
            container.sortItems();
    }

}
