/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.model;

import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.LifecycleElementState;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;

/**
 * Perform post-expression evaluation tasks.
 * 
 * <p>
 * This task is used for optimization in core KRAD features. Since expression evaluation can be
 * heavy, common behavior defined as expressions in delivered UIF components can be moved to this
 * task in order to handle evaluation in code instead.
 * </p>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class AfterEvaluateExpressionTask extends ViewLifecycleTaskBase<Component> {

    /**
     * Create a task to assign component IDs during the apply model phase.
     * 
     * @param phase The apply model phase for the component.
     */
    public AfterEvaluateExpressionTask() {
        super(Component.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void performLifecycleTask() {
        LifecycleElementState elementState = getElementState();
        if (!(elementState instanceof ViewLifecyclePhase)) {
            return;
        }
        
        ViewLifecyclePhase phase = (ViewLifecyclePhase) elementState;
        Component component = (Component) phase.getElement();
        component.afterEvaluateExpression();
    }

}
